//
//  Searching_the_Address_BookAppDelegate.m
//  Searching the Address Book
//
//  Created by Vandad Nahavandipoor on 21/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Searching_the_Address_BookAppDelegate.h"

@implementation Searching_the_Address_BookAppDelegate

@synthesize window = _window;

- (BOOL) doesPersonExistWithFirstName:(NSString *)paramFirstName
                             lastName:(NSString *)paramLastName
                        inAddressBook:(ABRecordRef)paramAddressBook{
  
  BOOL result = NO;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość NULL.");
    return NO;
  }
  
  NSArray *allPeople = (__bridge_transfer NSArray *)
                        ABAddressBookCopyArrayOfAllPeople(paramAddressBook);
  
  NSUInteger peopleCounter = 0;
  for (peopleCounter = 0;
       peopleCounter < [allPeople count];
       peopleCounter++){
    
    ABRecordRef person = (__bridge ABRecordRef)
                          [allPeople objectAtIndex:peopleCounter];
    
    NSString *firstName = (__bridge_transfer NSString *)
      ABRecordCopyValue(person, kABPersonFirstNameProperty);
    
    NSString *lastName = (__bridge_transfer NSString *)
      ABRecordCopyValue(person, kABPersonLastNameProperty);
    
    BOOL firstNameIsEqual = NO;
    BOOL lastNameIsEqual = NO;
    
    if ([firstName length] == 0 &&
        [paramFirstName length] == 0){
      firstNameIsEqual = YES;
    }
    else if ([firstName isEqualToString:paramFirstName]){
      firstNameIsEqual = YES;
    }
    
    if ([lastName length] == 0 &&
        [paramLastName length] == 0){
      lastNameIsEqual = YES;
    }
    else if ([lastName isEqualToString:paramLastName]){
      lastNameIsEqual = YES;
    }
    
    if (firstNameIsEqual &&
        lastNameIsEqual){
      return YES;
    }
    
  }
  
  return result;
  
}

- (BOOL) doesGroupExistWithGroupName:(NSString *)paramGroupName
                       inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  BOOL result = NO;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość NULL.");
    return NO;
  }
  
  NSArray *allGroups = (__bridge_transfer NSArray *)
                        ABAddressBookCopyArrayOfAllGroups(paramAddressBook);
  
  NSUInteger groupCounter = 0;
  for (groupCounter = 0;
       groupCounter < [allGroups count];
       groupCounter++){
    
    ABRecordRef group = (__bridge ABRecordRef)
                        [allGroups objectAtIndex:groupCounter];
    
    NSString *groupName = (__bridge_transfer NSString *)
                          ABRecordCopyValue(group, kABGroupNameProperty);
    
    if ([groupName length] == 0 &&
        [paramGroupName length] == 0){
      return YES;
    }
    
    else if ([groupName isEqualToString:paramGroupName]){
      return YES;
    }
    
  }
  
  return result;
  
}

/* 1 */
//- (ABRecordRef) newGroupWithName:(NSString *)paramGroupName
//                   inAddressBook:(ABAddressBookRef)paramAddressBook{
//  
//  ABRecordRef result = NULL;
//  
//  if (paramAddressBook == NULL){
//    NSLog(@"Książka adresowa ma wartość nil.");
//    return NULL;
//  }
//  
//  result = ABGroupCreate();
//  
//  if (result == NULL){
//    NSLog(@"Nie udało się utworzyć nowej grupy.");
//    return NULL;
//  }
//  
//  BOOL couldSetGroupName = NO;
//  CFErrorRef error = NULL;
//  
//  couldSetGroupName = ABRecordSetValue(result,
//                                       kABGroupNameProperty,
//                                       (__bridge CFTypeRef)paramGroupName,
//                                       &error);
//  
//  if (couldSetGroupName){
//    
//    BOOL couldAddRecord = NO;
//    CFErrorRef couldAddRecordError = NULL;
//    
//    couldAddRecord = ABAddressBookAddRecord(paramAddressBook, 
//                                            result,
//                                            &couldAddRecordError);
//    
//    if (couldAddRecord){
//      
//      NSLog(@"Udało się dodać nową grupę.");
//      
//      if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
//        BOOL couldSaveAddressBook = NO;
//        CFErrorRef couldSaveAddressBookError = NULL;
//        couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
//                                                 &couldSaveAddressBookError);
//        if (couldSaveAddressBook){
//          NSLog(@"Udało się zapisać zmiany w książce adresowej.");
//        } else {
//          CFRelease(result);
//          result = NULL;
//          NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
//        }
//      } else {
//        CFRelease(result);
//        result = NULL;
//        NSLog(@"Brak niezapisanych zmian.");
//      }
//    } else {
//      CFRelease(result);
//      result = NULL;
//      NSLog(@"Nie udało się dodać nowej grupy.");
//    }
//  } else {
//    CFRelease(result);
//    result = NULL;
//    NSLog(@"Nie udało się przypisać nazwy grupie.");
//  }
//  
//  return result;
//  
//}
//
//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  ABAddressBookRef addressBook = ABAddressBookCreate();
//  
//  if (addressBook != NULL){
//    
//    if ([self doesGroupExistWithGroupName:@"Helion"
//                            inAddressBook:addressBook]){
//      NSLog(@"Grupa Helion już istnieje w książce adresowej.");
//    } else {
//      
//      ABRecordRef oreillyGroup = [self newGroupWithName:@"O'Reilly"
//                                          inAddressBook:addressBook];
//      
//      if (oreillyGroup != NULL){
//        NSLog(@"Udało się utworzyć grupę Helion.");
//        CFRelease(oreillyGroup);
//      } else {
//        NSLog(@"Nie udało się utworzyć grupy Helion.");
//      }
//      
//    }
//    
//    CFRelease(addressBook);
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

/* 2 */

- (ABRecordRef) newPersonWithFirstName:(NSString *)paramFirstName
                              lastName:(NSString *)paramLastName
                         inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  ABRecordRef result = NULL;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość NULL.");
    return NULL;
  }
  
  if ([paramFirstName length] == 0 &&
      [paramLastName length] == 0){
    NSLog(@"Nie podano imienia i nazwiska.");
    return NULL;
  }
  
  result = ABPersonCreate();
  
  if (result == NULL){
    NSLog(@"Nie udało się utworzyć nowego kontaktu.");
    return NULL;
  }
  
  BOOL couldSetFirstName = NO;
  BOOL couldSetLastName = NO;
  CFErrorRef setFirstNameError = NULL;
  CFErrorRef setLastNameError = NULL;
  
  couldSetFirstName = ABRecordSetValue(result,
                                       kABPersonFirstNameProperty,
                                       (__bridge CFTypeRef)paramFirstName,
                                       &setFirstNameError);
  
  couldSetLastName = ABRecordSetValue(result,
                                      kABPersonLastNameProperty,
                                      (__bridge CFTypeRef)paramLastName,
                                      &setLastNameError);
  
  CFErrorRef couldAddPersonError = NULL;
  BOOL couldAddPerson = ABAddressBookAddRecord(paramAddressBook,
                                               result,
                                               &couldAddPersonError);
  
  if (couldAddPerson){
    NSLog(@"Udało się dodać nowy kontakt.");
  } else {
    NSLog(@"Nie udało się dodać nowego kontaktu.");
    CFRelease(result);
    result = NULL;
    return result;
  }
  
  if (ABAddressBookHasUnsavedChanges(paramAddressBook)){
    
    CFErrorRef couldSaveAddressBookError = NULL;
    BOOL couldSaveAddressBook = ABAddressBookSave(paramAddressBook, 
                                                  &couldSaveAddressBookError);
    
    if (couldSaveAddressBook){
      NSLog(@"Udało się zapisać zmiany w książce adresowej.");
    } else {
      NSLog(@"Nie udało się zapisać zmian w książce adresowej.");
    }
  }
  
  if (couldSetFirstName &&
      couldSetLastName){
    NSLog(@"Udało się zmienić imię i nazwisko kontaktu w książce adresowej.");
  } else {
    NSLog(@"Nie udało się zmienić imienia i nazwiska kontaktu w książce adresowej.");
  }
  
  return result;
  
}

- (BOOL) doesPersonExistWithFullName:(NSString *)paramFullName
                       inAddressBook:(ABAddressBookRef)paramAddressBook{
  
  BOOL result = NO;
  
  if (paramAddressBook == NULL){
    NSLog(@"Książka adresowa ma wartość null.");
    return NO;
  }
  
  NSArray *allPeopleWithThisName = (__bridge_transfer NSArray *)
  ABAddressBookCopyPeopleWithName(paramAddressBook,
                                  (__bridge CFStringRef)paramFullName);
  
  if ([allPeopleWithThisName count] > 0){
    result = YES;
  }
  
  return result;
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  ABAddressBookRef addressBook = ABAddressBookCreate();
  
  if (addressBook != NULL){
    
    if ([self doesPersonExistWithFullName:@"Natalia Malinowska"
                            inAddressBook:addressBook]){
      NSLog(@"Kontakt Natalia Malinowska istnieje w bazie danych.");
    } else {
      NSLog(@"Kontakt Natalia Malinowska nie istnieje w bazie danych.");
      
      ABRecordRef nataliaMalinowska = [self newPersonWithFirstName:@"Natalia"
                                                 		      lastName:@"Malinowska"
                                          	         inAddressBook:addressBook];
      
      if (nataliaMalinowska != NULL){
        NSLog(@"Udało się utworzyć rekord dla kontaktu Natalia Malinowska.");
        CFRelease(nataliaMalinowska);
      } else {
        NSLog(@"Nie udało się utworzyć rekordu dla kontaktu Natalia Malinowska.");
      }
      
    }
    
    CFRelease(addressBook);
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
